<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTODAccessMember StructType
 * @subpackage Structs
 */
class LTODAccessMember extends AbstractStructBase
{
    /**
     * The timeScheduleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $timeScheduleName;
    /**
     * The accessListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $accessListName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTODAccessMember
     * @uses LTODAccessMember::setTimeScheduleName()
     * @uses LTODAccessMember::setAccessListName()
     * @uses LTODAccessMember::setUuid()
     * @param \CUCM\StructType\XFkType $timeScheduleName
     * @param \CUCM\StructType\XFkType $accessListName
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $timeScheduleName = null, \CUCM\StructType\XFkType $accessListName = null, $uuid = null)
    {
        $this
            ->setTimeScheduleName($timeScheduleName)
            ->setAccessListName($accessListName)
            ->setUuid($uuid);
    }
    /**
     * Get timeScheduleName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTimeScheduleName()
    {
        return $this->timeScheduleName;
    }
    /**
     * Set timeScheduleName value
     * @param \CUCM\StructType\XFkType $timeScheduleName
     * @return \CUCM\StructType\LTODAccessMember
     */
    public function setTimeScheduleName(\CUCM\StructType\XFkType $timeScheduleName = null)
    {
        $this->timeScheduleName = $timeScheduleName;
        return $this;
    }
    /**
     * Get accessListName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAccessListName()
    {
        return $this->accessListName;
    }
    /**
     * Set accessListName value
     * @param \CUCM\StructType\XFkType $accessListName
     * @return \CUCM\StructType\LTODAccessMember
     */
    public function setAccessListName(\CUCM\StructType\XFkType $accessListName = null)
    {
        $this->accessListName = $accessListName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LTODAccessMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LTODAccessMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
