<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRoutePartition StructType
 * @subpackage Structs
 */
class LRoutePartition extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dialPlanWizardGenId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The timeScheduleIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRoutePartition
     * @uses LRoutePartition::setName()
     * @uses LRoutePartition::setDescription()
     * @uses LRoutePartition::setDialPlanWizardGenId()
     * @uses LRoutePartition::setTimeScheduleIdName()
     * @uses LRoutePartition::setUseOriginatingDeviceTimeZone()
     * @uses LRoutePartition::setTimeZone()
     * @uses LRoutePartition::setPartitionUsage()
     * @uses LRoutePartition::setUuid()
     * @param string $name
     * @param string $description
     * @param string $dialPlanWizardGenId
     * @param \CUCM\StructType\XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     * @param string $partitionUsage
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $dialPlanWizardGenId = null, \CUCM\StructType\XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = null, $timeZone = null, $partitionUsage = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone)
            ->setPartitionUsage($partitionUsage)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardGenId, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return $this->timeScheduleIdName;
    }
    /**
     * Set timeScheduleIdName value
     * @param \CUCM\StructType\XFkType $timeScheduleIdName
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setTimeScheduleIdName(\CUCM\StructType\XFkType $timeScheduleIdName = null)
    {
        $this->timeScheduleIdName = $timeScheduleIdName;
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useOriginatingDeviceTimeZone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useOriginatingDeviceTimeZone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useOriginatingDeviceTimeZone) && !is_string($useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useOriginatingDeviceTimeZone)), __LINE__);
        }
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \CUCM\EnumType\XTimeZone::valueIsValid()
     * @uses \CUCM\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \CUCM\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \CUCM\EnumType\XPartitionUsage::valueIsValid()
     * @uses \CUCM\EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partitionUsage, implode(', ', \CUCM\EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LRoutePartition
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LRoutePartition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
