<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LProcessNodeService StructType
 * @subpackage Structs
 */
class LProcessNodeService extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The traceLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxFileSize;
    /**
     * The isActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LProcessNodeService
     * @uses LProcessNodeService::setProcessNodeName()
     * @uses LProcessNodeService::setService()
     * @uses LProcessNodeService::setTraceLevel()
     * @uses LProcessNodeService::setUserCategories()
     * @uses LProcessNodeService::setEnable()
     * @uses LProcessNodeService::setNumFiles()
     * @uses LProcessNodeService::setMaxFileSize()
     * @uses LProcessNodeService::setIsActive()
     * @uses LProcessNodeService::setUuid()
     * @param \CUCM\StructType\XFkType $processNodeName
     * @param string $service
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     * @param string $isActive
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $processNodeName = null, $service = null, $traceLevel = null, $userCategories = null, $enable = null, $numFiles = null, $maxFileSize = null, $isActive = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize)
            ->setIsActive($isActive)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \CUCM\StructType\XFkType $processNodeName
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setProcessNodeName(\CUCM\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \CUCM\EnumType\XService::valueIsValid()
     * @uses \CUCM\EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service, implode(', ', \CUCM\EnumType\XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traceLevel
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setTraceLevel($traceLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($traceLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $traceLevel, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userCategories
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setUserCategories($userCategories = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($userCategories)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userCategories, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numFiles
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setNumFiles($numFiles = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numFiles)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numFiles, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxFileSize
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setMaxFileSize($maxFileSize = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxFileSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxFileSize, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActive) && !is_string($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LProcessNodeService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LProcessNodeService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
