<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPresenceGroupMember StructType
 * @subpackage Structs
 */
class LPresenceGroupMember extends AbstractStructBase
{
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscriptionPermission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionPermission;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPresenceGroupMember
     * @uses LPresenceGroupMember::setPresenceGroupName()
     * @uses LPresenceGroupMember::setSubscriptionPermission()
     * @uses LPresenceGroupMember::setUuid()
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param string $subscriptionPermission
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $presenceGroupName = null, $subscriptionPermission = null, $uuid = null)
    {
        $this
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscriptionPermission($subscriptionPermission)
            ->setUuid($uuid);
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\LPresenceGroupMember
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscriptionPermission value
     * @return string|null
     */
    public function getSubscriptionPermission()
    {
        return $this->subscriptionPermission;
    }
    /**
     * Set subscriptionPermission value
     * @uses \CUCM\EnumType\XMatrixValue::valueIsValid()
     * @uses \CUCM\EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPermission
     * @return \CUCM\StructType\LPresenceGroupMember
     */
    public function setSubscriptionPermission($subscriptionPermission = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMatrixValue::valueIsValid($subscriptionPermission)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriptionPermission, implode(', ', \CUCM\EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->subscriptionPermission = $subscriptionPermission;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LPresenceGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LPresenceGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
