<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMobileSmartClientProfile StructType
 * @subpackage Structs
 */
class LMobileSmartClientProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The mobileSmartClient
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobileSmartClient;
    /**
     * The enableSnrUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableSnrUri;
    /**
     * The enableCFAUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableCFAUri;
    /**
     * The handOffUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $handOffUri;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMobileSmartClientProfile
     * @uses LMobileSmartClientProfile::setName()
     * @uses LMobileSmartClientProfile::setMobileSmartClient()
     * @uses LMobileSmartClientProfile::setEnableSnrUri()
     * @uses LMobileSmartClientProfile::setEnableCFAUri()
     * @uses LMobileSmartClientProfile::setHandOffUri()
     * @uses LMobileSmartClientProfile::setUuid()
     * @param string $name
     * @param string $mobileSmartClient
     * @param string $enableSnrUri
     * @param string $enableCFAUri
     * @param string $handOffUri
     * @param string $uuid
     */
    public function __construct($name = null, $mobileSmartClient = null, $enableSnrUri = null, $enableCFAUri = null, $handOffUri = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setMobileSmartClient($mobileSmartClient)
            ->setEnableSnrUri($enableSnrUri)
            ->setEnableCFAUri($enableCFAUri)
            ->setHandOffUri($handOffUri)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mobileSmartClient value
     * @return string|null
     */
    public function getMobileSmartClient()
    {
        return $this->mobileSmartClient;
    }
    /**
     * Set mobileSmartClient value
     * @uses \CUCM\EnumType\XMobileSmartClient::valueIsValid()
     * @uses \CUCM\EnumType\XMobileSmartClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileSmartClient
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setMobileSmartClient($mobileSmartClient = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMobileSmartClient::valueIsValid($mobileSmartClient)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobileSmartClient, implode(', ', \CUCM\EnumType\XMobileSmartClient::getValidValues())), __LINE__);
        }
        $this->mobileSmartClient = $mobileSmartClient;
        return $this;
    }
    /**
     * Get enableSnrUri value
     * @return string|null
     */
    public function getEnableSnrUri()
    {
        return $this->enableSnrUri;
    }
    /**
     * Set enableSnrUri value
     * @param string $enableSnrUri
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setEnableSnrUri($enableSnrUri = null)
    {
        // validation for constraint: string
        if (!is_null($enableSnrUri) && !is_string($enableSnrUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableSnrUri)), __LINE__);
        }
        $this->enableSnrUri = $enableSnrUri;
        return $this;
    }
    /**
     * Get enableCFAUri value
     * @return string|null
     */
    public function getEnableCFAUri()
    {
        return $this->enableCFAUri;
    }
    /**
     * Set enableCFAUri value
     * @param string $enableCFAUri
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setEnableCFAUri($enableCFAUri = null)
    {
        // validation for constraint: string
        if (!is_null($enableCFAUri) && !is_string($enableCFAUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCFAUri)), __LINE__);
        }
        $this->enableCFAUri = $enableCFAUri;
        return $this;
    }
    /**
     * Get handOffUri value
     * @return string|null
     */
    public function getHandOffUri()
    {
        return $this->handOffUri;
    }
    /**
     * Set handOffUri value
     * @param string $handOffUri
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setHandOffUri($handOffUri = null)
    {
        // validation for constraint: string
        if (!is_null($handOffUri) && !is_string($handOffUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($handOffUri)), __LINE__);
        }
        $this->handOffUri = $handOffUri;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LMobileSmartClientProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
