<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMediaResourceListMember StructType
 * @subpackage Structs
 */
class LMediaResourceListMember extends AbstractStructBase
{
    /**
     * The mediaResourceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceGroupName;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $order;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMediaResourceListMember
     * @uses LMediaResourceListMember::setMediaResourceGroupName()
     * @uses LMediaResourceListMember::setOrder()
     * @uses LMediaResourceListMember::setUuid()
     * @param \CUCM\StructType\XFkType $mediaResourceGroupName
     * @param string $order
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $mediaResourceGroupName = null, $order = null, $uuid = null)
    {
        $this
            ->setMediaResourceGroupName($mediaResourceGroupName)
            ->setOrder($order)
            ->setUuid($uuid);
    }
    /**
     * Get mediaResourceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceGroupName()
    {
        return $this->mediaResourceGroupName;
    }
    /**
     * Set mediaResourceGroupName value
     * @param \CUCM\StructType\XFkType $mediaResourceGroupName
     * @return \CUCM\StructType\LMediaResourceListMember
     */
    public function setMediaResourceGroupName(\CUCM\StructType\XFkType $mediaResourceGroupName = null)
    {
        $this->mediaResourceGroupName = $mediaResourceGroupName;
        return $this;
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $order
     * @return \CUCM\StructType\LMediaResourceListMember
     */
    public function setOrder($order = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($order)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $order, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LMediaResourceListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LMediaResourceListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
