<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LHuntForwardInfoBusy StructType
 * @subpackage Structs
 */
class LHuntForwardInfoBusy extends AbstractStructBase
{
    /**
     * The usePersonalPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePersonalPreferences;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * The maxHuntduration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxHuntduration;
    /**
     * Constructor method for LHuntForwardInfoBusy
     * @uses LHuntForwardInfoBusy::setUsePersonalPreferences()
     * @uses LHuntForwardInfoBusy::setCallingSearchSpaceName()
     * @uses LHuntForwardInfoBusy::setDestination()
     * @uses LHuntForwardInfoBusy::setMaxHuntduration()
     * @param string $usePersonalPreferences
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     * @param string $maxHuntduration
     */
    public function __construct($usePersonalPreferences = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, $destination = null, $maxHuntduration = null)
    {
        $this
            ->setUsePersonalPreferences($usePersonalPreferences)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination)
            ->setMaxHuntduration($maxHuntduration);
    }
    /**
     * Get usePersonalPreferences value
     * @return string|null
     */
    public function getUsePersonalPreferences()
    {
        return $this->usePersonalPreferences;
    }
    /**
     * Set usePersonalPreferences value
     * @param string $usePersonalPreferences
     * @return \CUCM\StructType\LHuntForwardInfoBusy
     */
    public function setUsePersonalPreferences($usePersonalPreferences = null)
    {
        // validation for constraint: pattern
        if (is_scalar($usePersonalPreferences) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($usePersonalPreferences, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($usePersonalPreferences) && !is_string($usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePersonalPreferences)), __LINE__);
        }
        $this->usePersonalPreferences = $usePersonalPreferences;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\LHuntForwardInfoBusy
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \CUCM\StructType\LHuntForwardInfoBusy
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get maxHuntduration value
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return $this->maxHuntduration;
    }
    /**
     * Set maxHuntduration value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHuntduration
     * @return \CUCM\StructType\LHuntForwardInfoBusy
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxHuntduration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxHuntduration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxHuntduration = $maxHuntduration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LHuntForwardInfoBusy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
