<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LFallbackProfile StructType
 * @subpackage Structs
 */
class LFallbackProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callCss;
    /**
     * The callAnswerTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * The numberOfCorrelationDtmfDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfCorrelationDtmfDigits;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LFallbackProfile
     * @uses LFallbackProfile::setName()
     * @uses LFallbackProfile::setDescription()
     * @uses LFallbackProfile::setAdvertisedFallbackDirectoryE164Number()
     * @uses LFallbackProfile::setQosSensistivityLevel()
     * @uses LFallbackProfile::setCallCss()
     * @uses LFallbackProfile::setCallAnswerTimer()
     * @uses LFallbackProfile::setDirectoryNumberPartition()
     * @uses LFallbackProfile::setDirectoryNumber()
     * @uses LFallbackProfile::setNumberOfDigitsForCallerIDPartialMatch()
     * @uses LFallbackProfile::setNumberOfCorrelationDtmfDigits()
     * @uses LFallbackProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callCss
     * @param string $callAnswerTimer
     * @param \CUCM\StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @param string $numberOfCorrelationDtmfDigits
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = null, $callCss = null, $callAnswerTimer = null, \CUCM\StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = null, $numberOfCorrelationDtmfDigits = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallCss($callCss)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch)
            ->setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFallbackDirectoryE164Number) && !is_string($advertisedFallbackDirectoryE164Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertisedFallbackDirectoryE164Number)), __LINE__);
        }
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qosSensistivityLevel, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \CUCM\EnumType\XFallBackCSSSelection::valueIsValid()
     * @uses \CUCM\EnumType\XFallBackCSSSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XFallBackCSSSelection::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callCss, implode(', ', \CUCM\EnumType\XFallBackCSSSelection::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callAnswerTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return $this->directoryNumberPartition;
    }
    /**
     * Set directoryNumberPartition value
     * @param \CUCM\StructType\XFkType $directoryNumberPartition
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setDirectoryNumberPartition(\CUCM\StructType\XFkType $directoryNumberPartition = null)
    {
        $this->directoryNumberPartition = $directoryNumberPartition;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directoryNumber) && strlen($directoryNumber) > 16) || (is_array($directoryNumber) && count($directoryNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($directoryNumber) ? strlen($directoryNumber) : count($directoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numberOfDigitsForCallerIDPartialMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigitsForCallerIDPartialMatch, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
    /**
     * Get numberOfCorrelationDtmfDigits value
     * @return string|null
     */
    public function getNumberOfCorrelationDtmfDigits()
    {
        return $this->numberOfCorrelationDtmfDigits;
    }
    /**
     * Set numberOfCorrelationDtmfDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfCorrelationDtmfDigits
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numberOfCorrelationDtmfDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfCorrelationDtmfDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfCorrelationDtmfDigits = $numberOfCorrelationDtmfDigits;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LFallbackProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LFallbackProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
