<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDateTimeGroupNtpReference StructType
 * @subpackage Structs
 */
class LDateTimeGroupNtpReference extends AbstractStructBase
{
    /**
     * The phoneNtpName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $phoneNtpName;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDateTimeGroupNtpReference
     * @uses LDateTimeGroupNtpReference::setPhoneNtpName()
     * @uses LDateTimeGroupNtpReference::setSelectionOrder()
     * @uses LDateTimeGroupNtpReference::setUuid()
     * @param \CUCM\StructType\XFkType $phoneNtpName
     * @param string $selectionOrder
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $phoneNtpName = null, $selectionOrder = null, $uuid = null)
    {
        $this
            ->setPhoneNtpName($phoneNtpName)
            ->setSelectionOrder($selectionOrder)
            ->setUuid($uuid);
    }
    /**
     * Get phoneNtpName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPhoneNtpName()
    {
        return $this->phoneNtpName;
    }
    /**
     * Set phoneNtpName value
     * @param \CUCM\StructType\XFkType $phoneNtpName
     * @return \CUCM\StructType\LDateTimeGroupNtpReference
     */
    public function setPhoneNtpName(\CUCM\StructType\XFkType $phoneNtpName = null)
    {
        $this->phoneNtpName = $phoneNtpName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \CUCM\StructType\LDateTimeGroupNtpReference
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LDateTimeGroupNtpReference
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LDateTimeGroupNtpReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
