<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LConferenceBridge StructType
 * @subpackage Structs
 */
class LConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The subUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The maximumCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LConferenceBridge
     * @uses LConferenceBridge::setName()
     * @uses LConferenceBridge::setDescription()
     * @uses LConferenceBridge::setProduct()
     * @uses LConferenceBridge::setDevicePoolName()
     * @uses LConferenceBridge::setCommonDeviceConfigName()
     * @uses LConferenceBridge::setLocationName()
     * @uses LConferenceBridge::setSubUnit()
     * @uses LConferenceBridge::setLoadInformation()
     * @uses LConferenceBridge::setMaximumCapacity()
     * @uses LConferenceBridge::setUseTrustedRelayPoint()
     * @uses LConferenceBridge::setSecurityProfileName()
     * @uses LConferenceBridge::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param \CUCM\StructType\XFkType $locationName
     * @param string $subUnit
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, \CUCM\StructType\XFkType $locationName = null, $subUnit = null, \CUCM\StructType\XLoadInformation $loadInformation = null, $maximumCapacity = null, $useTrustedRelayPoint = null, \CUCM\StructType\XFkType $securityProfileName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setSubUnit($subUnit = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subUnit, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maximumCapacity, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setSecurityProfileName(\CUCM\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LConferenceBridge
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LConferenceBridge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
