<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCertificateRole StructType
 * @subpackage Structs
 */
class LCertificateRole extends AbstractStructBase
{
    /**
     * The roleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roleName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCertificateRole
     * @uses LCertificateRole::setRoleName()
     * @uses LCertificateRole::setUuid()
     * @param string $roleName
     * @param string $uuid
     */
    public function __construct($roleName = null, $uuid = null)
    {
        $this
            ->setRoleName($roleName)
            ->setUuid($uuid);
    }
    /**
     * Get roleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->roleName;
    }
    /**
     * Set roleName value
     * @uses \CUCM\EnumType\XTrustRole::valueIsValid()
     * @uses \CUCM\EnumType\XTrustRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleName
     * @return \CUCM\StructType\LCertificateRole
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrustRole::valueIsValid($roleName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roleName, implode(', ', \CUCM\EnumType\XTrustRole::getValidValues())), __LINE__);
        }
        $this->roleName = $roleName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LCertificateRole
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LCertificateRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
