<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCcdHostedDN StructType
 * @subpackage Structs
 */
class LCcdHostedDN extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $hostedPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The CcdHostedDnGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The pstnFailoverStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCcdHostedDN
     * @uses LCcdHostedDN::setHostedPattern()
     * @uses LCcdHostedDN::setDescription()
     * @uses LCcdHostedDN::setCcdHostedDnGroup()
     * @uses LCcdHostedDN::setPstnFailoverStripDigits()
     * @uses LCcdHostedDN::setPstnFailoverPrependDigits()
     * @uses LCcdHostedDN::setUsePstnFailover()
     * @uses LCcdHostedDN::setUuid()
     * @param string $hostedPattern
     * @param string $description
     * @param \CUCM\StructType\XFkType $ccdHostedDnGroup
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     * @param string $uuid
     */
    public function __construct($hostedPattern = null, $description = null, \CUCM\StructType\XFkType $ccdHostedDnGroup = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = null, $uuid = null)
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setDescription($description)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover)
            ->setUuid($uuid);
    }
    /**
     * Get hostedPattern value
     * @return string|null
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setHostedPattern($hostedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostedPattern) && strlen($hostedPattern) > 50) || (is_array($hostedPattern) && count($hostedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($hostedPattern) ? strlen($hostedPattern) : count($hostedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostedPattern) && !is_string($hostedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostedPattern)), __LINE__);
        }
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \CUCM\StructType\XFkType $ccdHostedDnGroup
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setCcdHostedDnGroup(\CUCM\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return $this->pstnFailoverStripDigits;
    }
    /**
     * Set pstnFailoverStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailoverStripDigits
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($pstnFailoverStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pstnFailoverStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pstnFailoverPrependDigits) && strlen($pstnFailoverPrependDigits) > 255) || (is_array($pstnFailoverPrependDigits) && count($pstnFailoverPrependDigits) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($pstnFailoverPrependDigits) ? strlen($pstnFailoverPrependDigits) : count($pstnFailoverPrependDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnFailoverPrependDigits) && !is_string($pstnFailoverPrependDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnFailoverPrependDigits)), __LINE__);
        }
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setUsePstnFailover($usePstnFailover = null)
    {
        // validation for constraint: pattern
        if (is_scalar($usePstnFailover) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($usePstnFailover, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($usePstnFailover) && !is_string($usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePstnFailover)), __LINE__);
        }
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LCcdHostedDN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
