<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCalledPartyTransformationPattern StructType
 * @subpackage Structs
 */
class LCalledPartyTransformationPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The calledPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyPrefixDigits;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCalledPartyTransformationPattern
     * @uses LCalledPartyTransformationPattern::setPattern()
     * @uses LCalledPartyTransformationPattern::setDescription()
     * @uses LCalledPartyTransformationPattern::setUsage()
     * @uses LCalledPartyTransformationPattern::setRoutePartitionName()
     * @uses LCalledPartyTransformationPattern::setCalledPartyTransformationMask()
     * @uses LCalledPartyTransformationPattern::setDialPlanName()
     * @uses LCalledPartyTransformationPattern::setDigitDiscardInstructionName()
     * @uses LCalledPartyTransformationPattern::setPatternUrgency()
     * @uses LCalledPartyTransformationPattern::setRouteFilterName()
     * @uses LCalledPartyTransformationPattern::setCalledPartyPrefixDigits()
     * @uses LCalledPartyTransformationPattern::setCalledPartyNumberingPlan()
     * @uses LCalledPartyTransformationPattern::setCalledPartyNumberType()
     * @uses LCalledPartyTransformationPattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param string $calledPartyTransformationMask
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @param \CUCM\StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param \CUCM\StructType\XFkType $routeFilterName
     * @param string $calledPartyPrefixDigits
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \CUCM\StructType\XFkType $routePartitionName = null, $calledPartyTransformationMask = null, \CUCM\StructType\XFkType $dialPlanName = null, \CUCM\StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, \CUCM\StructType\XFkType $routeFilterName = null, $calledPartyPrefixDigits = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setRouteFilterName($routeFilterName)
            ->setCalledPartyPrefixDigits($calledPartyPrefixDigits)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \CUCM\EnumType\XPatternUsage::valueIsValid()
     * @uses \CUCM\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', \CUCM\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setDialPlanName(\CUCM\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \CUCM\StructType\XFkType $digitDiscardInstructionName
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setDigitDiscardInstructionName(\CUCM\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($patternUrgency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patternUrgency)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \CUCM\StructType\XFkType $routeFilterName
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setRouteFilterName(\CUCM\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get calledPartyPrefixDigits value
     * @return string|null
     */
    public function getCalledPartyPrefixDigits()
    {
        return $this->calledPartyPrefixDigits;
    }
    /**
     * Set calledPartyPrefixDigits value
     * @param string $calledPartyPrefixDigits
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setCalledPartyPrefixDigits($calledPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyPrefixDigits) && !is_string($calledPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyPrefixDigits)), __LINE__);
        }
        $this->calledPartyPrefixDigits = $calledPartyPrefixDigits;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \CUCM\EnumType\XNumberingPlan::valueIsValid()
     * @uses \CUCM\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', \CUCM\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \CUCM\EnumType\XPriOfNumber::valueIsValid()
     * @uses \CUCM\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', \CUCM\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LCalledPartyTransformationPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
