<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for currentConfig StructType
 * @subpackage Structs
 */
class CurrentConfig extends AbstractStructBase
{
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null | This setting only effects devices that support MLPP. Use -1 to set to null | This setting only effects devices that support MLPP. Use -1 to set to null |
     * This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP. | This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable. | The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones
     * andand device profiles. Not Nullable. | The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable. | The new Ignore Presentation Indicators flag for Hospitality feature is
     * required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB. | This tag is valid only for devices that support SBB. | This tag is valid only for devices that support SBB. | This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL.. | This tag is valid only for devices that support JAL.. | This tag is valid only for devices that support JAL.. | This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The emccCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $emccCallingSearchSpaceName;
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $deviceName;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The deviceProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceProtocol;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The addressMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressMode;
    /**
     * The allowAutoConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowAutoConfig;
    /**
     * The remoteSrstOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $remoteSrstOption;
    /**
     * The remoteSrstIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $remoteSrstIp;
    /**
     * The remoteSrstPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSrstPort;
    /**
     * The remoteSipSrstIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $remoteSipSrstIp;
    /**
     * The remoteSipSrstPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSipSrstPort;
    /**
     * The geolocationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2048
     * @var string
     */
    public $geolocationInfo;
    /**
     * Constructor method for currentConfig
     * @uses CurrentConfig::setUserHoldMohAudioSourceId()
     * @uses CurrentConfig::setPhoneTemplateName()
     * @uses CurrentConfig::setMlppDomainId()
     * @uses CurrentConfig::setMlppIndicationStatus()
     * @uses CurrentConfig::setPreemption()
     * @uses CurrentConfig::setSoftkeyTemplateName()
     * @uses CurrentConfig::setIgnorePresentationIndicators()
     * @uses CurrentConfig::setSingleButtonBarge()
     * @uses CurrentConfig::setJoinAcrossLines()
     * @uses CurrentConfig::setCallInfoPrivacyStatus()
     * @uses CurrentConfig::setDndStatus()
     * @uses CurrentConfig::setDndRingSetting()
     * @uses CurrentConfig::setDndOption()
     * @uses CurrentConfig::setAlwaysUsePrimeLine()
     * @uses CurrentConfig::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses CurrentConfig::setEmccCallingSearchSpaceName()
     * @uses CurrentConfig::setDeviceName()
     * @uses CurrentConfig::setModel()
     * @uses CurrentConfig::setProduct()
     * @uses CurrentConfig::setDeviceProtocol()
     * @uses CurrentConfig::setClass()
     * @uses CurrentConfig::setAddressMode()
     * @uses CurrentConfig::setAllowAutoConfig()
     * @uses CurrentConfig::setRemoteSrstOption()
     * @uses CurrentConfig::setRemoteSrstIp()
     * @uses CurrentConfig::setRemoteSrstPort()
     * @uses CurrentConfig::setRemoteSipSrstIp()
     * @uses CurrentConfig::setRemoteSipSrstPort()
     * @uses CurrentConfig::setGeolocationInfo()
     * @param string $userHoldMohAudioSourceId
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @param string $ignorePresentationIndicators
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $callInfoPrivacyStatus
     * @param string $dndStatus
     * @param string $dndRingSetting
     * @param string $dndOption
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpaceName
     * @param string $deviceName
     * @param string $model
     * @param string $product
     * @param string $deviceProtocol
     * @param string $class
     * @param string $addressMode
     * @param string $allowAutoConfig
     * @param string $remoteSrstOption
     * @param string $remoteSrstIp
     * @param string $remoteSrstPort
     * @param string $remoteSipSrstIp
     * @param string $remoteSipSrstPort
     * @param string $geolocationInfo
     */
    public function __construct($userHoldMohAudioSourceId = null, \CUCM\StructType\XFkType $phoneTemplateName = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, \CUCM\StructType\XFkType $softkeyTemplateName = null, $ignorePresentationIndicators = null, $singleButtonBarge = null, $joinAcrossLines = null, $callInfoPrivacyStatus = null, $dndStatus = null, $dndRingSetting = null, $dndOption = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \CUCM\StructType\XFkType $emccCallingSearchSpaceName = null, $deviceName = null, $model = null, $product = null, $deviceProtocol = null, $class = null, $addressMode = null, $allowAutoConfig = null, $remoteSrstOption = null, $remoteSrstIp = null, $remoteSrstPort = null, $remoteSipSrstIp = null, $remoteSipSrstPort = null, $geolocationInfo = null)
    {
        $this
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setDndStatus($dndStatus)
            ->setDndRingSetting($dndRingSetting)
            ->setDndOption($dndOption)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setEmccCallingSearchSpaceName($emccCallingSearchSpaceName)
            ->setDeviceName($deviceName)
            ->setModel($model)
            ->setProduct($product)
            ->setDeviceProtocol($deviceProtocol)
            ->setClass($class)
            ->setAddressMode($addressMode)
            ->setAllowAutoConfig($allowAutoConfig)
            ->setRemoteSrstOption($remoteSrstOption)
            ->setRemoteSrstIp($remoteSrstIp)
            ->setRemoteSrstPort($remoteSrstPort)
            ->setRemoteSipSrstIp($remoteSipSrstIp)
            ->setRemoteSipSrstPort($remoteSipSrstPort)
            ->setGeolocationInfo($geolocationInfo);
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setPhoneTemplateName(\CUCM\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \CUCM\EnumType\XPreemption::valueIsValid()
     * @uses \CUCM\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \CUCM\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setSoftkeyTemplateName(\CUCM\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \CUCM\EnumType\XBarge::valueIsValid()
     * @uses \CUCM\EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \CUCM\EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \CUCM\EnumType\XDNDOption::valueIsValid()
     * @uses \CUCM\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \CUCM\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get emccCallingSearchSpaceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getEmccCallingSearchSpaceName()
    {
        return $this->emccCallingSearchSpaceName;
    }
    /**
     * Set emccCallingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpaceName
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setEmccCallingSearchSpaceName(\CUCM\StructType\XFkType $emccCallingSearchSpaceName = null)
    {
        $this->emccCallingSearchSpaceName = $emccCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deviceName) && strlen($deviceName) > 255) || (is_array($deviceName) && count($deviceName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($deviceName) ? strlen($deviceName) : count($deviceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \CUCM\EnumType\XModel::valueIsValid()
     * @uses \CUCM\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \CUCM\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get deviceProtocol value
     * @return string|null
     */
    public function getDeviceProtocol()
    {
        return $this->deviceProtocol;
    }
    /**
     * Set deviceProtocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceProtocol
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setDeviceProtocol($deviceProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($deviceProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceProtocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->deviceProtocol = $deviceProtocol;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get addressMode value
     * @return string|null
     */
    public function getAddressMode()
    {
        return $this->addressMode;
    }
    /**
     * Set addressMode value
     * @uses \CUCM\EnumType\XIPAddressingMode::valueIsValid()
     * @uses \CUCM\EnumType\XIPAddressingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressMode
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setAddressMode($addressMode = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XIPAddressingMode::valueIsValid($addressMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addressMode, implode(', ', \CUCM\EnumType\XIPAddressingMode::getValidValues())), __LINE__);
        }
        $this->addressMode = $addressMode;
        return $this;
    }
    /**
     * Get allowAutoConfig value
     * @return string|null
     */
    public function getAllowAutoConfig()
    {
        return $this->allowAutoConfig;
    }
    /**
     * Set allowAutoConfig value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowAutoConfig
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setAllowAutoConfig($allowAutoConfig = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($allowAutoConfig)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allowAutoConfig, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowAutoConfig = $allowAutoConfig;
        return $this;
    }
    /**
     * Get remoteSrstOption value
     * @return string|null
     */
    public function getRemoteSrstOption()
    {
        return $this->remoteSrstOption;
    }
    /**
     * Set remoteSrstOption value
     * @param string $remoteSrstOption
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setRemoteSrstOption($remoteSrstOption = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteSrstOption) && strlen($remoteSrstOption) > 50) || (is_array($remoteSrstOption) && count($remoteSrstOption) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($remoteSrstOption) ? strlen($remoteSrstOption) : count($remoteSrstOption)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteSrstOption) && !is_string($remoteSrstOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteSrstOption)), __LINE__);
        }
        $this->remoteSrstOption = $remoteSrstOption;
        return $this;
    }
    /**
     * Get remoteSrstIp value
     * @return string|null
     */
    public function getRemoteSrstIp()
    {
        return $this->remoteSrstIp;
    }
    /**
     * Set remoteSrstIp value
     * @param string $remoteSrstIp
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setRemoteSrstIp($remoteSrstIp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteSrstIp) && strlen($remoteSrstIp) > 15) || (is_array($remoteSrstIp) && count($remoteSrstIp) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($remoteSrstIp) ? strlen($remoteSrstIp) : count($remoteSrstIp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteSrstIp) && !is_string($remoteSrstIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteSrstIp)), __LINE__);
        }
        $this->remoteSrstIp = $remoteSrstIp;
        return $this;
    }
    /**
     * Get remoteSrstPort value
     * @return string|null
     */
    public function getRemoteSrstPort()
    {
        return $this->remoteSrstPort;
    }
    /**
     * Set remoteSrstPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteSrstPort
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setRemoteSrstPort($remoteSrstPort = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($remoteSrstPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteSrstPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteSrstPort = $remoteSrstPort;
        return $this;
    }
    /**
     * Get remoteSipSrstIp value
     * @return string|null
     */
    public function getRemoteSipSrstIp()
    {
        return $this->remoteSipSrstIp;
    }
    /**
     * Set remoteSipSrstIp value
     * @param string $remoteSipSrstIp
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setRemoteSipSrstIp($remoteSipSrstIp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteSipSrstIp) && strlen($remoteSipSrstIp) > 15) || (is_array($remoteSipSrstIp) && count($remoteSipSrstIp) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($remoteSipSrstIp) ? strlen($remoteSipSrstIp) : count($remoteSipSrstIp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteSipSrstIp) && !is_string($remoteSipSrstIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteSipSrstIp)), __LINE__);
        }
        $this->remoteSipSrstIp = $remoteSipSrstIp;
        return $this;
    }
    /**
     * Get remoteSipSrstPort value
     * @return string|null
     */
    public function getRemoteSipSrstPort()
    {
        return $this->remoteSipSrstPort;
    }
    /**
     * Set remoteSipSrstPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteSipSrstPort
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setRemoteSipSrstPort($remoteSipSrstPort = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($remoteSipSrstPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteSipSrstPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteSipSrstPort = $remoteSipSrstPort;
        return $this;
    }
    /**
     * Get geolocationInfo value
     * @return string|null
     */
    public function getGeolocationInfo()
    {
        return $this->geolocationInfo;
    }
    /**
     * Set geolocationInfo value
     * @param string $geolocationInfo
     * @return \CUCM\StructType\CurrentConfig
     */
    public function setGeolocationInfo($geolocationInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($geolocationInfo) && strlen($geolocationInfo) > 2048) || (is_array($geolocationInfo) && count($geolocationInfo) > 2048)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2048 element(s) or a scalar of 2048 character(s) at most, "%d" length given', is_scalar($geolocationInfo) ? strlen($geolocationInfo) : count($geolocationInfo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($geolocationInfo) && !is_string($geolocationInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geolocationInfo)), __LINE__);
        }
        $this->geolocationInfo = $geolocationInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\CurrentConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
