<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certificates StructType
 * @subpackage Structs
 */
class Certificates extends AbstractStructBase
{
    /**
     * The certificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \CUCM\StructType\XVpnGatewayMember[]
     */
    public $certificate;
    /**
     * Constructor method for certificates
     * @uses Certificates::setCertificate()
     * @param \CUCM\StructType\XVpnGatewayMember[] $certificate
     */
    public function __construct(array $certificate = array())
    {
        $this
            ->setCertificate($certificate);
    }
    /**
     * Get certificate value
     * @return \CUCM\StructType\XVpnGatewayMember[]|null
     */
    public function getCertificate()
    {
        return $this->certificate;
    }
    /**
     * Set certificate value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XVpnGatewayMember[] $certificate
     * @return \CUCM\StructType\Certificates
     */
    public function setCertificate(array $certificate = array())
    {
        foreach ($certificate as $certificatesCertificateItem) {
            // validation for constraint: itemType
            if (!$certificatesCertificateItem instanceof \CUCM\StructType\XVpnGatewayMember) {
                throw new \InvalidArgumentException(sprintf('The certificate property can only contain items of \CUCM\StructType\XVpnGatewayMember, "%s" given', is_object($certificatesCertificateItem) ? get_class($certificatesCertificateItem) : gettype($certificatesCertificateItem)), __LINE__);
            }
        }
        $this->certificate = $certificate;
        return $this;
    }
    /**
     * Add item to certificate value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XVpnGatewayMember $item
     * @return \CUCM\StructType\Certificates
     */
    public function addToCertificate(\CUCM\StructType\XVpnGatewayMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\XVpnGatewayMember) {
            throw new \InvalidArgumentException(sprintf('The certificate property can only contain items of \CUCM\StructType\XVpnGatewayMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->certificate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\Certificates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
