<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedGroups StructType
 * @subpackage Structs
 */
class AssociatedGroups extends AbstractStructBase
{
    /**
     * The userGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CUCM\StructType\UserGroup[]
     */
    public $userGroup;
    /**
     * Constructor method for associatedGroups
     * @uses AssociatedGroups::setUserGroup()
     * @param \CUCM\StructType\UserGroup[] $userGroup
     */
    public function __construct(array $userGroup = array())
    {
        $this
            ->setUserGroup($userGroup);
    }
    /**
     * Get userGroup value
     * @return \CUCM\StructType\UserGroup[]|null
     */
    public function getUserGroup()
    {
        return $this->userGroup;
    }
    /**
     * Set userGroup value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\UserGroup[] $userGroup
     * @return \CUCM\StructType\AssociatedGroups
     */
    public function setUserGroup(array $userGroup = array())
    {
        foreach ($userGroup as $associatedGroupsUserGroupItem) {
            // validation for constraint: itemType
            if (!$associatedGroupsUserGroupItem instanceof \CUCM\StructType\UserGroup) {
                throw new \InvalidArgumentException(sprintf('The userGroup property can only contain items of \CUCM\StructType\UserGroup, "%s" given', is_object($associatedGroupsUserGroupItem) ? get_class($associatedGroupsUserGroupItem) : gettype($associatedGroupsUserGroupItem)), __LINE__);
            }
        }
        $this->userGroup = $userGroup;
        return $this;
    }
    /**
     * Add item to userGroup value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\UserGroup $item
     * @return \CUCM\StructType\AssociatedGroups
     */
    public function addToUserGroup(\CUCM\StructType\UserGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\UserGroup) {
            throw new \InvalidArgumentException(sprintf('The userGroup property can only contain items of \CUCM\StructType\UserGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->userGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\AssociatedGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
