<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for appUsers StructType
 * Meta informations extracted from the WSDL
 * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer | Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
 * @subpackage Structs
 */
class AppUsers extends XCommonMembersExtension
{
    /**
     * The selectedAppUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CUCM\StructType\SelectedAppUser[]
     */
    public $selectedAppUser;
    /**
     * Constructor method for appUsers
     * @uses AppUsers::setSelectedAppUser()
     * @param \CUCM\StructType\SelectedAppUser[] $selectedAppUser
     */
    public function __construct(array $selectedAppUser = array())
    {
        $this
            ->setSelectedAppUser($selectedAppUser);
    }
    /**
     * Get selectedAppUser value
     * @return \CUCM\StructType\SelectedAppUser[]|null
     */
    public function getSelectedAppUser()
    {
        return $this->selectedAppUser;
    }
    /**
     * Set selectedAppUser value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\SelectedAppUser[] $selectedAppUser
     * @return \CUCM\StructType\AppUsers
     */
    public function setSelectedAppUser(array $selectedAppUser = array())
    {
        foreach ($selectedAppUser as $appUsersSelectedAppUserItem) {
            // validation for constraint: itemType
            if (!$appUsersSelectedAppUserItem instanceof \CUCM\StructType\SelectedAppUser) {
                throw new \InvalidArgumentException(sprintf('The selectedAppUser property can only contain items of \CUCM\StructType\SelectedAppUser, "%s" given', is_object($appUsersSelectedAppUserItem) ? get_class($appUsersSelectedAppUserItem) : gettype($appUsersSelectedAppUserItem)), __LINE__);
            }
        }
        $this->selectedAppUser = $selectedAppUser;
        return $this;
    }
    /**
     * Add item to selectedAppUser value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\SelectedAppUser $item
     * @return \CUCM\StructType\AppUsers
     */
    public function addToSelectedAppUser(\CUCM\StructType\SelectedAppUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\SelectedAppUser) {
            throw new \InvalidArgumentException(sprintf('The selectedAppUser property can only contain items of \CUCM\StructType\SelectedAppUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->selectedAppUser[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\AppUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
