<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addPlars StructType
 * @subpackage Structs
 */
class AddPlars extends XCommonMembersExtension
{
    /**
     * The plar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \CUCM\StructType\XPatternMember[]
     */
    public $plar;
    /**
     * Constructor method for addPlars
     * @uses AddPlars::setPlar()
     * @param \CUCM\StructType\XPatternMember[] $plar
     */
    public function __construct(array $plar = array())
    {
        $this
            ->setPlar($plar);
    }
    /**
     * Get plar value
     * @return \CUCM\StructType\XPatternMember[]
     */
    public function getPlar()
    {
        return $this->plar;
    }
    /**
     * Set plar value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPatternMember[] $plar
     * @return \CUCM\StructType\AddPlars
     */
    public function setPlar(array $plar = array())
    {
        foreach ($plar as $addPlarsPlarItem) {
            // validation for constraint: itemType
            if (!$addPlarsPlarItem instanceof \CUCM\StructType\XPatternMember) {
                throw new \InvalidArgumentException(sprintf('The plar property can only contain items of \CUCM\StructType\XPatternMember, "%s" given', is_object($addPlarsPlarItem) ? get_class($addPlarsPlarItem) : gettype($addPlarsPlarItem)), __LINE__);
            }
        }
        $this->plar = $plar;
        return $this;
    }
    /**
     * Add item to plar value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPatternMember $item
     * @return \CUCM\StructType\AddPlars
     */
    public function addToPlar(\CUCM\StructType\XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The plar property can only contain items of \CUCM\StructType\XPatternMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->plar[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\AddPlars
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
