<?php

namespace CUCM\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipTrunkSecurityProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTimePeriod(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTimeSchedule(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTodAccess(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveVoiceMailPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVoiceMailPilot(\CUCM\StructType\RemoveVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeProcessNode(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCallerFilterList(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRoutePartition(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCss(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMediaResourceGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMediaResourceList(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRegion(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeAarGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePhysicalLocation(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRouteGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDevicePool(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDeviceMobilityGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeLocation(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSoftKeyTemplate(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTranscoder(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCommonDeviceConfig(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveResourcePriorityNamespaceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespace(\CUCM\StructType\RemoveResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespaceList(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDeviceMobility(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCmcInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCmcInfo(\CUCM\StructType\RemoveCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCredentialPolicy(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeFacInfo(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeHuntList(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveIvrUserLocaleReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeIvrUserLocale(\CUCM\StructType\RemoveIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeLineGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRecordingProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRouteFilter(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCallManagerGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeUserGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveMohAudioSourceReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMohAudioSource(\CUCM\StructType\RemoveMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveDhcpServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDhcpServer(\CUCM\StructType\RemoveDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveDhcpSubnetReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDhcpSubnet(\CUCM\StructType\RemoveDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCallPark(\CUCM\StructType\RemoveCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveDirectedCallParkReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDirectedCallPark(\CUCM\StructType\RemoveDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveMeetMeReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMeetMe(\CUCM\StructType\RemoveMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveMobileVoiceAccessReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMobileVoiceAccess(\CUCM\StructType\RemoveMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRouteList(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeUser(\CUCM\StructType\RemoveUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveAppUserReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeAppUser(\CUCM\StructType\RemoveAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveSipRealmReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipRealm(\CUCM\StructType\RemoveSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemovePhoneNtpReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePhoneNtp(\CUCM\StructType\RemovePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDateTimeGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePresenceGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGeoLocation(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSrst(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveMlppDomainReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMlppDomain(\CUCM\StructType\RemoveMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCumaServerSecurityProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveApplicationServerReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeApplicationServer(\CUCM\StructType\RemoveApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveApplicationUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeApplicationUserCapfProfile(\CUCM\StructType\RemoveApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveEndUserCapfProfileReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeEndUserCapfProfile(\CUCM\StructType\RemoveEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGeoLocationFilter(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVoiceMailProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVoiceMailPort(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatekeeper(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePhoneButtonTemplate(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCommonPhoneConfig(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveMessageWaitingReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMessageWaiting(\CUCM\StructType\RemoveMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveIpPhoneServicesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeIpPhoneServices(\CUCM\StructType\RemoveIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCtiRoutePoint(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveTransPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTransPattern(\CUCM\StructType\RemoveTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCallingPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCallingPartyTransformationPattern(\CUCM\StructType\RemoveCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveSipRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipRoutePattern(\CUCM\StructType\RemoveSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveHuntPilotReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeHuntPilot(\CUCM\StructType\RemoveHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveRoutePatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRoutePattern(\CUCM\StructType\RemoveRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeApplicationDialRules(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDirectoryLookupDialRules(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePhoneSecurityProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipDialRules(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeConferenceBridge(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMtp(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRemoteDestinationProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveLineReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeLine(\CUCM\StructType\RemoveLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDefaultDeviceProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeH323Phone(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeH323Trunk(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removePhone(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeH323Gateway(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeDeviceProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveRemoteDestinationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRemoteDestination(\CUCM\StructType\RemoveRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGateway(\CUCM\StructType\RemoveGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointAnalogAccess(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessPri(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessBri(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessT1(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveVg224Req $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVg224(\CUCM\StructType\RemoveVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst600024PortFXSGateway(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000E1VoIPGateway(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayPri(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayT1(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCallPickupGroupReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCallPickupGroup(\CUCM\StructType\RemoveCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGeoLocationPolicy(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSipTrunk(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCalledPartyTransformationPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCalledPartyTransformationPattern(\CUCM\StructType\RemoveCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeExternalCallControlProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSafSecurityProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSafForwarder(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveCcdHostedDNReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCcdHostedDN(\CUCM\StructType\RemoveCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCcdHostedDNGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCcdRequestingService(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveRemoteClusterReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeRemoteCluster(\CUCM\StructType\RemoveRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeCcdAdvertisingService(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeLdapDirectory(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeSafCcdPurgeBlockLearnedRoutes(\CUCM\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVpnGateway(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVpnGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeVpnProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeServer(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterElement(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeClient(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveImeEnrolledPatternReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPattern(\CUCM\StructType\RemoveImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPatternGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveImeExclusionNumberReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumber(\CUCM\StructType\RemoveImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumberGroup(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeFirewall(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeE164Transformation(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeTransformationProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeFallbackProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeLdapFilter(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeFeatureControlPolicy(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\NameAndGUIDRequest $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeMobilityProfile(\CUCM\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeEnterpriseFeatureAccessConfiguration(\CUCM\StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveHandoffConfigurationReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeHandoffConfiguration(\CUCM\StructType\RemoveHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeApplicationToSoftkeyTemplate(\CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveUnitsToGatewayReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeUnitsToGateway(\CUCM\StructType\RemoveUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveGatewaySubunitsReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeGatewaySubunits(\CUCM\StructType\RemoveGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveImeLearnedRoutesReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeImeLearnedRoutes(\CUCM\StructType\RemoveImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CUCM\StructType\RemoveAppServerInfoReq $axlParams
     * @return \CUCM\StructType\StandardResponse|bool
     */
    public function removeAppServerInfo(\CUCM\StructType\RemoveAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CUCM\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
