<?php

namespace CUCM\EnumType;

/**
 * This class stands for XUserProfile EnumType
 * @subpackage Enumerations
 */
class XUserProfile
{
    /**
     * Constant for value 'Real User'
     * @return string 'Real User'
     */
    const VALUE_REAL_USER = 'Real User';
    /**
     * Constant for value 'Template User'
     * @return string 'Template User'
     */
    const VALUE_TEMPLATE_USER = 'Template User';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REAL_USER
     * @uses self::VALUE_TEMPLATE_USER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REAL_USER,
            self::VALUE_TEMPLATE_USER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
