<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTrunkService EnumType
 * @subpackage Enumerations
 */
class XTrunkService
{
    /**
     * Constant for value 'None(Default)'
     * @return string 'None(Default)'
     */
    const VALUE_NONE_DEFAULT = 'None(Default)';
    /**
     * Constant for value 'Call Control Discovery'
     * @return string 'Call Control Discovery'
     */
    const VALUE_CALL_CONTROL_DISCOVERY = 'Call Control Discovery';
    /**
     * Constant for value 'Extension Mobility Cross Cluster'
     * @return string 'Extension Mobility Cross Cluster'
     */
    const VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER = 'Extension Mobility Cross Cluster';
    /**
     * Constant for value 'Cisco Intercompany Media Engine'
     * @return string 'Cisco Intercompany Media Engine'
     */
    const VALUE_CISCO_INTERCOMPANY_MEDIA_ENGINE = 'Cisco Intercompany Media Engine';
    /**
     * Constant for value 'IP Multimedia Subsystem Service Control (ISC)'
     * @return string 'IP Multimedia Subsystem Service Control (ISC)'
     */
    const VALUE_IP_MULTIMEDIA_SUBSYSTEM_SERVICE_CONTROL_ISC = 'IP Multimedia Subsystem Service Control (ISC)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE_DEFAULT
     * @uses self::VALUE_CALL_CONTROL_DISCOVERY
     * @uses self::VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER
     * @uses self::VALUE_CISCO_INTERCOMPANY_MEDIA_ENGINE
     * @uses self::VALUE_IP_MULTIMEDIA_SUBSYSTEM_SERVICE_CONTROL_ISC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE_DEFAULT,
            self::VALUE_CALL_CONTROL_DISCOVERY,
            self::VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER,
            self::VALUE_CISCO_INTERCOMPANY_MEDIA_ENGINE,
            self::VALUE_IP_MULTIMEDIA_SUBSYSTEM_SERVICE_CONTROL_ISC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
