<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTrunkSelectionOrder EnumType
 * @subpackage Enumerations
 */
class XTrunkSelectionOrder
{
    /**
     * Constant for value 'Bottom Up'
     * @return string 'Bottom Up'
     */
    const VALUE_BOTTOM_UP = 'Bottom Up';
    /**
     * Constant for value 'Top Down'
     * @return string 'Top Down'
     */
    const VALUE_TOP_DOWN = 'Top Down';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOTTOM_UP
     * @uses self::VALUE_TOP_DOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOTTOM_UP,
            self::VALUE_TOP_DOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
