<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTimeScheduleCategory EnumType
 * @subpackage Enumerations
 */
class XTimeScheduleCategory
{
    /**
     * Constant for value 'Regular'
     * @return string 'Regular'
     */
    const VALUE_REGULAR = 'Regular';
    /**
     * Constant for value 'Holiday or Vacation'
     * @return string 'Holiday or Vacation'
     */
    const VALUE_HOLIDAY_OR_VACATION = 'Holiday or Vacation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR
     * @uses self::VALUE_HOLIDAY_OR_VACATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR,
            self::VALUE_HOLIDAY_OR_VACATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
