<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTerminal EnumType
 * @subpackage Enumerations
 */
class XTerminal
{
    /**
     * Constant for value '-- Not Selected --'
     * @return string '-- Not Selected --'
     */
    const VALUE_NOT_SELECTED = '-- Not Selected --';
    /**
     * Constant for value 'Terminal'
     * @return string 'Terminal'
     */
    const VALUE_TERMINAL = 'Terminal';
    /**
     * Constant for value 'Gateway'
     * @return string 'Gateway'
     */
    const VALUE_GATEWAY = 'Gateway';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SELECTED
     * @uses self::VALUE_TERMINAL
     * @uses self::VALUE_GATEWAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SELECTED,
            self::VALUE_TERMINAL,
            self::VALUE_GATEWAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
