<?php

namespace CUCM\EnumType;

/**
 * This class stands for XTaskStatus EnumType
 * @subpackage Enumerations
 */
class XTaskStatus
{
    /**
     * Constant for value 'Not Running'
     * @return string 'Not Running'
     */
    const VALUE_NOT_RUNNING = 'Not Running';
    /**
     * Constant for value 'Idle'
     * @return string 'Idle'
     */
    const VALUE_IDLE = 'Idle';
    /**
     * Constant for value 'In Progress'
     * @return string 'In Progress'
     */
    const VALUE_IN_PROGRESS = 'In Progress';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_RUNNING
     * @uses self::VALUE_IDLE
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_COMPLETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_RUNNING,
            self::VALUE_IDLE,
            self::VALUE_IN_PROGRESS,
            self::VALUE_COMPLETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
