<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSyslogMessage EnumType
 * @subpackage Enumerations
 */
class XSyslogMessage
{
    /**
     * Constant for value 'Security'
     * @return string 'Security'
     */
    const VALUE_SECURITY = 'Security';
    /**
     * Constant for value 'System'
     * @return string 'System'
     */
    const VALUE_SYSTEM = 'System';
    /**
     * Constant for value 'Application'
     * @return string 'Application'
     */
    const VALUE_APPLICATION = 'Application';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SECURITY
     * @uses self::VALUE_SYSTEM
     * @uses self::VALUE_APPLICATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SECURITY,
            self::VALUE_SYSTEM,
            self::VALUE_APPLICATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
