<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSite EnumType
 * @subpackage Enumerations
 */
class XSite
{
    /**
     * Constant for value 'Central'
     * @return string 'Central'
     */
    const VALUE_CENTRAL = 'Central';
    /**
     * Constant for value 'TeleWorkers'
     * @return string 'TeleWorkers'
     */
    const VALUE_TELE_WORKERS = 'TeleWorkers';
    /**
     * Constant for value 'Branch'
     * @return string 'Branch'
     */
    const VALUE_BRANCH = 'Branch';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CENTRAL
     * @uses self::VALUE_TELE_WORKERS
     * @uses self::VALUE_BRANCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CENTRAL,
            self::VALUE_TELE_WORKERS,
            self::VALUE_BRANCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
