<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSilenceSuppressionThreshold EnumType
 * @subpackage Enumerations
 */
class XSilenceSuppressionThreshold
{
    /**
     * Constant for value 'Disable'
     * @return string 'Disable'
     */
    const VALUE_DISABLE = 'Disable';
    /**
     * Constant for value '-48dbm0'
     * @return string '-48dbm0'
     */
    const VALUE_48_DBM_0 = '-48dbm0';
    /**
     * Constant for value '-45dbm0'
     * @return string '-45dbm0'
     */
    const VALUE_45_DBM_0 = '-45dbm0';
    /**
     * Constant for value '-42dbm0'
     * @return string '-42dbm0'
     */
    const VALUE_42_DBM_0 = '-42dbm0';
    /**
     * Constant for value '-39dbm0'
     * @return string '-39dbm0'
     */
    const VALUE_39_DBM_0 = '-39dbm0';
    /**
     * Constant for value '-36dbm0'
     * @return string '-36dbm0'
     */
    const VALUE_36_DBM_0 = '-36dbm0';
    /**
     * Constant for value '-33dbm0'
     * @return string '-33dbm0'
     */
    const VALUE_33_DBM_0 = '-33dbm0';
    /**
     * Constant for value '-30dbm0'
     * @return string '-30dbm0'
     */
    const VALUE_30_DBM_0 = '-30dbm0';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLE
     * @uses self::VALUE_48_DBM_0
     * @uses self::VALUE_45_DBM_0
     * @uses self::VALUE_42_DBM_0
     * @uses self::VALUE_39_DBM_0
     * @uses self::VALUE_36_DBM_0
     * @uses self::VALUE_33_DBM_0
     * @uses self::VALUE_30_DBM_0
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLE,
            self::VALUE_48_DBM_0,
            self::VALUE_45_DBM_0,
            self::VALUE_42_DBM_0,
            self::VALUE_39_DBM_0,
            self::VALUE_36_DBM_0,
            self::VALUE_33_DBM_0,
            self::VALUE_30_DBM_0,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
