<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSIPTrunkCallLegSecurity EnumType
 * @subpackage Enumerations
 */
class XSIPTrunkCallLegSecurity
{
    /**
     * Constant for value 'When using both sRTP and TLS'
     * @return string 'When using both sRTP and TLS'
     */
    const VALUE_WHEN_USING_BOTH_S_RTP_AND_TLS = 'When using both sRTP and TLS';
    /**
     * Constant for value 'When using sRTP Only'
     * @return string 'When using sRTP Only'
     */
    const VALUE_WHEN_USING_S_RTP_ONLY = 'When using sRTP Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WHEN_USING_BOTH_S_RTP_AND_TLS
     * @uses self::VALUE_WHEN_USING_S_RTP_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WHEN_USING_BOTH_S_RTP_AND_TLS,
            self::VALUE_WHEN_USING_S_RTP_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
