<?php

namespace CUCM\EnumType;

/**
 * This class stands for XSIPScriptErrorHandling EnumType
 * @subpackage Enumerations
 */
class XSIPScriptErrorHandling
{
    /**
     * Constant for value 'Message Rollback Only'
     * @return string 'Message Rollback Only'
     */
    const VALUE_MESSAGE_ROLLBACK_ONLY = 'Message Rollback Only';
    /**
     * Constant for value 'Disable Script'
     * @return string 'Disable Script'
     */
    const VALUE_DISABLE_SCRIPT = 'Disable Script';
    /**
     * Constant for value 'Reset Script'
     * @return string 'Reset Script'
     */
    const VALUE_RESET_SCRIPT = 'Reset Script';
    /**
     * Constant for value 'Reset Trunk'
     * @return string 'Reset Trunk'
     */
    const VALUE_RESET_TRUNK = 'Reset Trunk';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MESSAGE_ROLLBACK_ONLY
     * @uses self::VALUE_DISABLE_SCRIPT
     * @uses self::VALUE_RESET_SCRIPT
     * @uses self::VALUE_RESET_TRUNK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MESSAGE_ROLLBACK_ONLY,
            self::VALUE_DISABLE_SCRIPT,
            self::VALUE_RESET_SCRIPT,
            self::VALUE_RESET_TRUNK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
