<?php

namespace CUCM\EnumType;

/**
 * This class stands for XRingSetting EnumType
 * @subpackage Enumerations
 */
class XRingSetting
{
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'Disable'
     * @return string 'Disable'
     */
    const VALUE_DISABLE = 'Disable';
    /**
     * Constant for value 'Flash Only'
     * @return string 'Flash Only'
     */
    const VALUE_FLASH_ONLY = 'Flash Only';
    /**
     * Constant for value 'Ring Once'
     * @return string 'Ring Once'
     */
    const VALUE_RING_ONCE = 'Ring Once';
    /**
     * Constant for value 'Ring'
     * @return string 'Ring'
     */
    const VALUE_RING = 'Ring';
    /**
     * Constant for value 'Beep Only'
     * @return string 'Beep Only'
     */
    const VALUE_BEEP_ONLY = 'Beep Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_DISABLE
     * @uses self::VALUE_FLASH_ONLY
     * @uses self::VALUE_RING_ONCE
     * @uses self::VALUE_RING
     * @uses self::VALUE_BEEP_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_DISABLE,
            self::VALUE_FLASH_ONLY,
            self::VALUE_RING_ONCE,
            self::VALUE_RING,
            self::VALUE_BEEP_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
