<?php

namespace CUCM\EnumType;

/**
 * This class stands for XRecordingFlag EnumType
 * @subpackage Enumerations
 */
class XRecordingFlag
{
    /**
     * Constant for value 'Call Recording Disabled'
     * @return string 'Call Recording Disabled'
     */
    const VALUE_CALL_RECORDING_DISABLED = 'Call Recording Disabled';
    /**
     * Constant for value 'Automatic Call Recording Enabled'
     * @return string 'Automatic Call Recording Enabled'
     */
    const VALUE_AUTOMATIC_CALL_RECORDING_ENABLED = 'Automatic Call Recording Enabled';
    /**
     * Constant for value 'Application Invoked Call Recording Enabled'
     * @return string 'Application Invoked Call Recording Enabled'
     */
    const VALUE_APPLICATION_INVOKED_CALL_RECORDING_ENABLED = 'Application Invoked Call Recording Enabled';
    /**
     * Constant for value 'Device Invoked Call Recording Enabled'
     * @return string 'Device Invoked Call Recording Enabled'
     */
    const VALUE_DEVICE_INVOKED_CALL_RECORDING_ENABLED = 'Device Invoked Call Recording Enabled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALL_RECORDING_DISABLED
     * @uses self::VALUE_AUTOMATIC_CALL_RECORDING_ENABLED
     * @uses self::VALUE_APPLICATION_INVOKED_CALL_RECORDING_ENABLED
     * @uses self::VALUE_DEVICE_INVOKED_CALL_RECORDING_ENABLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALL_RECORDING_DISABLED,
            self::VALUE_AUTOMATIC_CALL_RECORDING_ENABLED,
            self::VALUE_APPLICATION_INVOKED_CALL_RECORDING_ENABLED,
            self::VALUE_DEVICE_INVOKED_CALL_RECORDING_ENABLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
