<?php

namespace CUCM\EnumType;

/**
 * This class stands for XProvider EnumType
 * @subpackage Enumerations
 */
class XProvider
{
    /**
     * Constant for value 'Base Provider'
     * @return string 'Base Provider'
     */
    const VALUE_BASE_PROVIDER = 'Base Provider';
    /**
     * Constant for value 'Custom Provider'
     * @return string 'Custom Provider'
     */
    const VALUE_CUSTOM_PROVIDER = 'Custom Provider';
    /**
     * Constant for value 'Merge Provider'
     * @return string 'Merge Provider'
     */
    const VALUE_MERGE_PROVIDER = 'Merge Provider';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASE_PROVIDER
     * @uses self::VALUE_CUSTOM_PROVIDER
     * @uses self::VALUE_MERGE_PROVIDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE_PROVIDER,
            self::VALUE_CUSTOM_PROVIDER,
            self::VALUE_MERGE_PROVIDER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
