<?php

namespace CUCM\EnumType;

/**
 * This class stands for XProductCategory EnumType
 * @subpackage Enumerations
 */
class XProductCategory
{
    /**
     * Constant for value 'New Other Unrecognized'
     * @return string 'New Other Unrecognized'
     */
    const VALUE_NEW_OTHER_UNRECOGNIZED = 'New Other Unrecognized';
    /**
     * Constant for value 'Cisco Common Data Services'
     * @return string 'Cisco Common Data Services'
     */
    const VALUE_CISCO_COMMON_DATA_SERVICES = 'Cisco Common Data Services';
    /**
     * Constant for value 'Cisco Unified Communications Manager'
     * @return string 'Cisco Unified Communications Manager'
     */
    const VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER = 'Cisco Unified Communications Manager';
    /**
     * Constant for value 'Cisco Unified Presence'
     * @return string 'Cisco Unified Presence'
     */
    const VALUE_CISCO_UNIFIED_PRESENCE = 'Cisco Unified Presence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW_OTHER_UNRECOGNIZED
     * @uses self::VALUE_CISCO_COMMON_DATA_SERVICES
     * @uses self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER
     * @uses self::VALUE_CISCO_UNIFIED_PRESENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW_OTHER_UNRECOGNIZED,
            self::VALUE_CISCO_COMMON_DATA_SERVICES,
            self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER,
            self::VALUE_CISCO_UNIFIED_PRESENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
