<?php

namespace CUCM\EnumType;

/**
 * This class stands for XPlatformCertificate EnumType
 * @subpackage Enumerations
 */
class XPlatformCertificate
{
    /**
     * Constant for value 'Tomcat'
     * @return string 'Tomcat'
     */
    const VALUE_TOMCAT = 'Tomcat';
    /**
     * Constant for value 'IPSec'
     * @return string 'IPSec'
     */
    const VALUE_IPSEC = 'IPSec';
    /**
     * Constant for value 'CallManager'
     * @return string 'CallManager'
     */
    const VALUE_CALL_MANAGER = 'CallManager';
    /**
     * Constant for value 'CAPF'
     * @return string 'CAPF'
     */
    const VALUE_CAPF = 'CAPF';
    /**
     * Constant for value 'Directory'
     * @return string 'Directory'
     */
    const VALUE_DIRECTORY = 'Directory';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOMCAT
     * @uses self::VALUE_IPSEC
     * @uses self::VALUE_CALL_MANAGER
     * @uses self::VALUE_CAPF
     * @uses self::VALUE_DIRECTORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOMCAT,
            self::VALUE_IPSEC,
            self::VALUE_CALL_MANAGER,
            self::VALUE_CAPF,
            self::VALUE_DIRECTORY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
