<?php

namespace CUCM\EnumType;

/**
 * This class stands for XPipeSize EnumType
 * @subpackage Enumerations
 */
class XPipeSize
{
    /**
     * Constant for value 'T1(1.5 Mbits)'
     * @return string 'T1(1.5 Mbits)'
     */
    const VALUE_T_1_1_5_MBITS = 'T1(1.5 Mbits)';
    /**
     * Constant for value 'Half T1 (768 Kbits)'
     * @return string 'Half T1 (768 Kbits)'
     */
    const VALUE_HALF_T_1_768_KBITS = 'Half T1 (768 Kbits)';
    /**
     * Constant for value '2 Channel BRI(144 Kbits)'
     * @return string '2 Channel BRI(144 Kbits)'
     */
    const VALUE_2_CHANNEL_BRI_144_KBITS = '2 Channel BRI(144 Kbits)';
    /**
     * Constant for value 'Half E1(1 Mbit)'
     * @return string 'Half E1(1 Mbit)'
     */
    const VALUE_HALF_E_1_1_MBIT = 'Half E1(1 Mbit)';
    /**
     * Constant for value 'E1(2 Mbits)'
     * @return string 'E1(2 Mbits)'
     */
    const VALUE_E_1_2_MBITS = 'E1(2 Mbits)';
    /**
     * Constant for value '10 Mbits'
     * @return string '10 Mbits'
     */
    const VALUE_10_MBITS = '10 Mbits';
    /**
     * Constant for value '100 Mbits'
     * @return string '100 Mbits'
     */
    const VALUE_100_MBITS = '100 Mbits';
    /**
     * Constant for value '1 Gbit'
     * @return string '1 Gbit'
     */
    const VALUE_1_GBIT = '1 Gbit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_T_1_1_5_MBITS
     * @uses self::VALUE_HALF_T_1_768_KBITS
     * @uses self::VALUE_2_CHANNEL_BRI_144_KBITS
     * @uses self::VALUE_HALF_E_1_1_MBIT
     * @uses self::VALUE_E_1_2_MBITS
     * @uses self::VALUE_10_MBITS
     * @uses self::VALUE_100_MBITS
     * @uses self::VALUE_1_GBIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_T_1_1_5_MBITS,
            self::VALUE_HALF_T_1_768_KBITS,
            self::VALUE_2_CHANNEL_BRI_144_KBITS,
            self::VALUE_HALF_E_1_1_MBIT,
            self::VALUE_E_1_2_MBITS,
            self::VALUE_10_MBITS,
            self::VALUE_100_MBITS,
            self::VALUE_1_GBIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
