<?php

namespace CUCM\EnumType;

/**
 * This class stands for XPattern EnumType
 * @subpackage Enumerations
 */
class XPattern
{
    /**
     * Constant for value 'Pattern'
     * @return string 'Pattern'
     */
    const VALUE_PATTERN = 'Pattern';
    /**
     * Constant for value 'Plar'
     * @return string 'Plar'
     */
    const VALUE_PLAR = 'Plar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PATTERN
     * @uses self::VALUE_PLAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PATTERN,
            self::VALUE_PLAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
