<?php

namespace CUCM\EnumType;

/**
 * This class stands for XPacketCaptureMode EnumType
 * @subpackage Enumerations
 */
class XPacketCaptureMode
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Batch Processing Mode'
     * @return string 'Batch Processing Mode'
     */
    const VALUE_BATCH_PROCESSING_MODE = 'Batch Processing Mode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_BATCH_PROCESSING_MODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_BATCH_PROCESSING_MODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
