<?php

namespace CUCM\EnumType;

/**
 * This class stands for XNetworkLocation EnumType
 * @subpackage Enumerations
 */
class XNetworkLocation
{
    /**
     * Constant for value 'OnNet'
     * @return string 'OnNet'
     */
    const VALUE_ON_NET = 'OnNet';
    /**
     * Constant for value 'OffNet'
     * @return string 'OffNet'
     */
    const VALUE_OFF_NET = 'OffNet';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_NET
     * @uses self::VALUE_OFF_NET
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_NET,
            self::VALUE_OFF_NET,
            self::VALUE_USE_SYSTEM_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
