<?php

namespace CUCM\EnumType;

/**
 * This class stands for XNameDisplayFormat EnumType
 * @subpackage Enumerations
 */
class XNameDisplayFormat
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'First Name Last Name'
     * @return string 'First Name Last Name'
     */
    const VALUE_FIRST_NAME_LAST_NAME = 'First Name Last Name';
    /**
     * Constant for value 'Last Name, First Name'
     * @return string 'Last Name, First Name'
     */
    const VALUE_LAST_NAME_FIRST_NAME = 'Last Name, First Name';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_FIRST_NAME_LAST_NAME
     * @uses self::VALUE_LAST_NAME_FIRST_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_FIRST_NAME_LAST_NAME,
            self::VALUE_LAST_NAME_FIRST_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
