<?php

namespace CUCM\EnumType;

/**
 * This class stands for XMixer EnumType
 * @subpackage Enumerations
 */
class XMixer
{
    /**
     * Constant for value 'Not Selected'
     * @return string 'Not Selected'
     */
    const VALUE_NOT_SELECTED = 'Not Selected';
    /**
     * Constant for value 'Multicast Point'
     * @return string 'Multicast Point'
     */
    const VALUE_MULTICAST_POINT = 'Multicast Point';
    /**
     * Constant for value 'Unicast Bridge'
     * @return string 'Unicast Bridge'
     */
    const VALUE_UNICAST_BRIDGE = 'Unicast Bridge';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SELECTED
     * @uses self::VALUE_MULTICAST_POINT
     * @uses self::VALUE_UNICAST_BRIDGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SELECTED,
            self::VALUE_MULTICAST_POINT,
            self::VALUE_UNICAST_BRIDGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
