<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLicenseFeature EnumType
 * @subpackage Enumerations
 */
class XLicenseFeature
{
    /**
     * Constant for value 'CCM Node'
     * @return string 'CCM Node'
     */
    const VALUE_CCM_NODE = 'CCM Node';
    /**
     * Constant for value 'Phone Unit'
     * @return string 'Phone Unit'
     */
    const VALUE_PHONE_UNIT = 'Phone Unit';
    /**
     * Constant for value 'SW Version'
     * @return string 'SW Version'
     */
    const VALUE_SW_VERSION = 'SW Version';
    /**
     * Constant for value 'Enhanced User License'
     * @return string 'Enhanced User License'
     */
    const VALUE_ENHANCED_USER_LICENSE = 'Enhanced User License';
    /**
     * Constant for value 'Basic User License'
     * @return string 'Basic User License'
     */
    const VALUE_BASIC_USER_LICENSE = 'Basic User License';
    /**
     * Constant for value 'Essential User License'
     * @return string 'Essential User License'
     */
    const VALUE_ESSENTIAL_USER_LICENSE = 'Essential User License';
    /**
     * Constant for value 'Adjunct Device License'
     * @return string 'Adjunct Device License'
     */
    const VALUE_ADJUNCT_DEVICE_LICENSE = 'Adjunct Device License';
    /**
     * Constant for value 'Voice Mail License'
     * @return string 'Voice Mail License'
     */
    const VALUE_VOICE_MAIL_LICENSE = 'Voice Mail License';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CCM_NODE
     * @uses self::VALUE_PHONE_UNIT
     * @uses self::VALUE_SW_VERSION
     * @uses self::VALUE_ENHANCED_USER_LICENSE
     * @uses self::VALUE_BASIC_USER_LICENSE
     * @uses self::VALUE_ESSENTIAL_USER_LICENSE
     * @uses self::VALUE_ADJUNCT_DEVICE_LICENSE
     * @uses self::VALUE_VOICE_MAIL_LICENSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CCM_NODE,
            self::VALUE_PHONE_UNIT,
            self::VALUE_SW_VERSION,
            self::VALUE_ENHANCED_USER_LICENSE,
            self::VALUE_BASIC_USER_LICENSE,
            self::VALUE_ESSENTIAL_USER_LICENSE,
            self::VALUE_ADJUNCT_DEVICE_LICENSE,
            self::VALUE_VOICE_MAIL_LICENSE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
