<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLdapServerAttr EnumType
 * @subpackage Enumerations
 */
class XLdapServerAttr
{
    /**
     * Constant for value 'UniqueIdentifier'
     * @return string 'UniqueIdentifier'
     */
    const VALUE_UNIQUE_IDENTIFIER = 'UniqueIdentifier';
    /**
     * Constant for value 'UserId'
     * @return string 'UserId'
     */
    const VALUE_USER_ID = 'UserId';
    /**
     * Constant for value 'FirstName'
     * @return string 'FirstName'
     */
    const VALUE_FIRST_NAME = 'FirstName';
    /**
     * Constant for value 'MiddleName'
     * @return string 'MiddleName'
     */
    const VALUE_MIDDLE_NAME = 'MiddleName';
    /**
     * Constant for value 'LastName'
     * @return string 'LastName'
     */
    const VALUE_LAST_NAME = 'LastName';
    /**
     * Constant for value 'Manager'
     * @return string 'Manager'
     */
    const VALUE_MANAGER = 'Manager';
    /**
     * Constant for value 'Department'
     * @return string 'Department'
     */
    const VALUE_DEPARTMENT = 'Department';
    /**
     * Constant for value 'TelephoneNumber'
     * @return string 'TelephoneNumber'
     */
    const VALUE_TELEPHONE_NUMBER = 'TelephoneNumber';
    /**
     * Constant for value 'Mailid'
     * @return string 'Mailid'
     */
    const VALUE_MAILID = 'Mailid';
    /**
     * Constant for value 'Title'
     * @return string 'Title'
     */
    const VALUE_TITLE = 'Title';
    /**
     * Constant for value 'HomePhone'
     * @return string 'HomePhone'
     */
    const VALUE_HOME_PHONE = 'HomePhone';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Constant for value 'Pager'
     * @return string 'Pager'
     */
    const VALUE_PAGER = 'Pager';
    /**
     * Constant for value 'OCSPrimaryUserAddress'
     * @return string 'OCSPrimaryUserAddress'
     */
    const VALUE_OCSPRIMARY_USER_ADDRESS = 'OCSPrimaryUserAddress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNIQUE_IDENTIFIER
     * @uses self::VALUE_USER_ID
     * @uses self::VALUE_FIRST_NAME
     * @uses self::VALUE_MIDDLE_NAME
     * @uses self::VALUE_LAST_NAME
     * @uses self::VALUE_MANAGER
     * @uses self::VALUE_DEPARTMENT
     * @uses self::VALUE_TELEPHONE_NUMBER
     * @uses self::VALUE_MAILID
     * @uses self::VALUE_TITLE
     * @uses self::VALUE_HOME_PHONE
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_PAGER
     * @uses self::VALUE_OCSPRIMARY_USER_ADDRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNIQUE_IDENTIFIER,
            self::VALUE_USER_ID,
            self::VALUE_FIRST_NAME,
            self::VALUE_MIDDLE_NAME,
            self::VALUE_LAST_NAME,
            self::VALUE_MANAGER,
            self::VALUE_DEPARTMENT,
            self::VALUE_TELEPHONE_NUMBER,
            self::VALUE_MAILID,
            self::VALUE_TITLE,
            self::VALUE_HOME_PHONE,
            self::VALUE_MOBILE,
            self::VALUE_PAGER,
            self::VALUE_OCSPRIMARY_USER_ADDRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
