<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLdapServer EnumType
 * @subpackage Enumerations
 */
class XLdapServer
{
    /**
     * Constant for value 'Microsoft Active Directory'
     * @return string 'Microsoft Active Directory'
     */
    const VALUE_MICROSOFT_ACTIVE_DIRECTORY = 'Microsoft Active Directory';
    /**
     * Constant for value 'iPlanet or Sun ONE LDAP Server'
     * @return string 'iPlanet or Sun ONE LDAP Server'
     */
    const VALUE_I_PLANET_OR_SUN_ONE_LDAP_SERVER = 'iPlanet or Sun ONE LDAP Server';
    /**
     * Constant for value 'OpenLDAP'
     * @return string 'OpenLDAP'
     */
    const VALUE_OPEN_LDAP = 'OpenLDAP';
    /**
     * Constant for value 'Microsoft Active Directory Application Mode'
     * @return string 'Microsoft Active Directory Application Mode'
     */
    const VALUE_MICROSOFT_ACTIVE_DIRECTORY_APPLICATION_MODE = 'Microsoft Active Directory Application Mode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MICROSOFT_ACTIVE_DIRECTORY
     * @uses self::VALUE_I_PLANET_OR_SUN_ONE_LDAP_SERVER
     * @uses self::VALUE_OPEN_LDAP
     * @uses self::VALUE_MICROSOFT_ACTIVE_DIRECTORY_APPLICATION_MODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MICROSOFT_ACTIVE_DIRECTORY,
            self::VALUE_I_PLANET_OR_SUN_ONE_LDAP_SERVER,
            self::VALUE_OPEN_LDAP,
            self::VALUE_MICROSOFT_ACTIVE_DIRECTORY_APPLICATION_MODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
