<?php

namespace CUCM\EnumType;

/**
 * This class stands for XLampBlinkRate EnumType
 * @subpackage Enumerations
 */
class XLampBlinkRate
{
    /**
     * Constant for value 'Lamp Off'
     * @return string 'Lamp Off'
     */
    const VALUE_LAMP_OFF = 'Lamp Off';
    /**
     * Constant for value 'Lamp On'
     * @return string 'Lamp On'
     */
    const VALUE_LAMP_ON = 'Lamp On';
    /**
     * Constant for value 'Wink'
     * @return string 'Wink'
     */
    const VALUE_WINK = 'Wink';
    /**
     * Constant for value 'Flash'
     * @return string 'Flash'
     */
    const VALUE_FLASH = 'Flash';
    /**
     * Constant for value 'Blink'
     * @return string 'Blink'
     */
    const VALUE_BLINK = 'Blink';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAMP_OFF
     * @uses self::VALUE_LAMP_ON
     * @uses self::VALUE_WINK
     * @uses self::VALUE_FLASH
     * @uses self::VALUE_BLINK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAMP_OFF,
            self::VALUE_LAMP_ON,
            self::VALUE_WINK,
            self::VALUE_FLASH,
            self::VALUE_BLINK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
