<?php

namespace CUCM\EnumType;

/**
 * This class stands for XKeyAuthority EnumType
 * @subpackage Enumerations
 */
class XKeyAuthority
{
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'lsc'
     * @return string 'lsc'
     */
    const VALUE_LSC = 'lsc';
    /**
     * Constant for value 'mic'
     * @return string 'mic'
     */
    const VALUE_MIC = 'mic';
    /**
     * Constant for value 'symmetric key'
     * @return string 'symmetric key'
     */
    const VALUE_SYMMETRIC_KEY = 'symmetric key';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_LSC
     * @uses self::VALUE_MIC
     * @uses self::VALUE_SYMMETRIC_KEY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_LSC,
            self::VALUE_MIC,
            self::VALUE_SYMMETRIC_KEY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
