<?php

namespace CUCM\EnumType;

/**
 * This class stands for XInterClusterService EnumType
 * @subpackage Enumerations
 */
class XInterClusterService
{
    /**
     * Constant for value 'EMCC'
     * @return string 'EMCC'
     */
    const VALUE_EMCC = 'EMCC';
    /**
     * Constant for value 'PSTN Access'
     * @return string 'PSTN Access'
     */
    const VALUE_PSTN_ACCESS = 'PSTN Access';
    /**
     * Constant for value 'RSVP Agent'
     * @return string 'RSVP Agent'
     */
    const VALUE_RSVP_AGENT = 'RSVP Agent';
    /**
     * Constant for value 'TFTP'
     * @return string 'TFTP'
     */
    const VALUE_TFTP = 'TFTP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMCC
     * @uses self::VALUE_PSTN_ACCESS
     * @uses self::VALUE_RSVP_AGENT
     * @uses self::VALUE_TFTP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMCC,
            self::VALUE_PSTN_ACCESS,
            self::VALUE_RSVP_AGENT,
            self::VALUE_TFTP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
