<?php

namespace CUCM\EnumType;

/**
 * This class stands for XIDSAuditLevel EnumType
 * @subpackage Enumerations
 */
class XIDSAuditLevel
{
    /**
     * Constant for value 'Schema Only'
     * @return string 'Schema Only'
     */
    const VALUE_SCHEMA_ONLY = 'Schema Only';
    /**
     * Constant for value 'Administrative Tasks'
     * @return string 'Administrative Tasks'
     */
    const VALUE_ADMINISTRATIVE_TASKS = 'Administrative Tasks';
    /**
     * Constant for value 'Database Updates'
     * @return string 'Database Updates'
     */
    const VALUE_DATABASE_UPDATES = 'Database Updates';
    /**
     * Constant for value 'Database Reads'
     * @return string 'Database Reads'
     */
    const VALUE_DATABASE_READS = 'Database Reads';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCHEMA_ONLY
     * @uses self::VALUE_ADMINISTRATIVE_TASKS
     * @uses self::VALUE_DATABASE_UPDATES
     * @uses self::VALUE_DATABASE_READS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCHEMA_ONLY,
            self::VALUE_ADMINISTRATIVE_TASKS,
            self::VALUE_DATABASE_UPDATES,
            self::VALUE_DATABASE_READS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
