<?php

namespace CUCM\EnumType;

/**
 * This class stands for XGlobalSetting EnumType
 * @subpackage Enumerations
 */
class XGlobalSetting
{
    /**
     * Constant for value 'Mobility Default EFA DN NumPlan Reference'
     * @return string 'Mobility Default EFA DN NumPlan Reference'
     */
    const VALUE_MOBILITY_DEFAULT_EFA_DN_NUM_PLAN_REFERENCE = 'Mobility Default EFA DN NumPlan Reference';
    /**
     * Constant for value 'Do Not Disturb Option'
     * @return string 'Do Not Disturb Option'
     */
    const VALUE_DO_NOT_DISTURB_OPTION = 'Do Not Disturb Option';
    /**
     * Constant for value 'Incoming Alert Signal On DND'
     * @return string 'Incoming Alert Signal On DND'
     */
    const VALUE_INCOMING_ALERT_SIGNAL_ON_DND = 'Incoming Alert Signal On DND';
    /**
     * Constant for value 'Username of Secure Shell Client User'
     * @return string 'Username of Secure Shell Client User'
     */
    const VALUE_USERNAME_OF_SECURE_SHELL_CLIENT_USER = 'Username of Secure Shell Client User';
    /**
     * Constant for value 'Password of Secure Shell Client User'
     * @return string 'Password of Secure Shell Client User'
     */
    const VALUE_PASSWORD_OF_SECURE_SHELL_CLIENT_USER = 'Password of Secure Shell Client User';
    /**
     * Constant for value 'Display Format for Internal CallerID'
     * @return string 'Display Format for Internal CallerID'
     */
    const VALUE_DISPLAY_FORMAT_FOR_INTERNAL_CALLER_ID = 'Display Format for Internal CallerID';
    /**
     * Constant for value 'Display Format for Line Text Label'
     * @return string 'Display Format for Line Text Label'
     */
    const VALUE_DISPLAY_FORMAT_FOR_LINE_TEXT_LABEL = 'Display Format for Line Text Label';
    /**
     * Constant for value 'Maximum size of DN Trace Log File in MegaBytes.'
     * @return string 'Maximum size of DN Trace Log File in MegaBytes.'
     */
    const VALUE_MAXIMUM_SIZE_OF_DN_TRACE_LOG_FILE_IN_MEGA_BYTES = 'Maximum size of DN Trace Log File in MegaBytes.';
    /**
     * Constant for value 'Maximum number of DN Trace log Files'
     * @return string 'Maximum number of DN Trace log Files'
     */
    const VALUE_MAXIMUM_NUMBER_OF_DN_TRACE_LOG_FILES = 'Maximum number of DN Trace log Files';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MOBILITY_DEFAULT_EFA_DN_NUM_PLAN_REFERENCE
     * @uses self::VALUE_DO_NOT_DISTURB_OPTION
     * @uses self::VALUE_INCOMING_ALERT_SIGNAL_ON_DND
     * @uses self::VALUE_USERNAME_OF_SECURE_SHELL_CLIENT_USER
     * @uses self::VALUE_PASSWORD_OF_SECURE_SHELL_CLIENT_USER
     * @uses self::VALUE_DISPLAY_FORMAT_FOR_INTERNAL_CALLER_ID
     * @uses self::VALUE_DISPLAY_FORMAT_FOR_LINE_TEXT_LABEL
     * @uses self::VALUE_MAXIMUM_SIZE_OF_DN_TRACE_LOG_FILE_IN_MEGA_BYTES
     * @uses self::VALUE_MAXIMUM_NUMBER_OF_DN_TRACE_LOG_FILES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MOBILITY_DEFAULT_EFA_DN_NUM_PLAN_REFERENCE,
            self::VALUE_DO_NOT_DISTURB_OPTION,
            self::VALUE_INCOMING_ALERT_SIGNAL_ON_DND,
            self::VALUE_USERNAME_OF_SECURE_SHELL_CLIENT_USER,
            self::VALUE_PASSWORD_OF_SECURE_SHELL_CLIENT_USER,
            self::VALUE_DISPLAY_FORMAT_FOR_INTERNAL_CALLER_ID,
            self::VALUE_DISPLAY_FORMAT_FOR_LINE_TEXT_LABEL,
            self::VALUE_MAXIMUM_SIZE_OF_DN_TRACE_LOG_FILE_IN_MEGA_BYTES,
            self::VALUE_MAXIMUM_NUMBER_OF_DN_TRACE_LOG_FILES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
