<?php

namespace CUCM\EnumType;

/**
 * This class stands for XFeatureControl EnumType
 * @subpackage Enumerations
 */
class XFeatureControl
{
    /**
     * Constant for value 'Forward All'
     * @return string 'Forward All'
     */
    const VALUE_FORWARD_ALL = 'Forward All';
    /**
     * Constant for value 'Park'
     * @return string 'Park'
     */
    const VALUE_PARK = 'Park';
    /**
     * Constant for value 'Divert (Alerting)'
     * @return string 'Divert (Alerting)'
     */
    const VALUE_DIVERT_ALERTING = 'Divert (Alerting)';
    /**
     * Constant for value 'Conference List'
     * @return string 'Conference List'
     */
    const VALUE_CONFERENCE_LIST = 'Conference List';
    /**
     * Constant for value 'Speed Dial'
     * @return string 'Speed Dial'
     */
    const VALUE_SPEED_DIAL = 'Speed Dial';
    /**
     * Constant for value 'Call Back'
     * @return string 'Call Back'
     */
    const VALUE_CALL_BACK = 'Call Back';
    /**
     * Constant for value 'Redial'
     * @return string 'Redial'
     */
    const VALUE_REDIAL = 'Redial';
    /**
     * Constant for value 'Barge'
     * @return string 'Barge'
     */
    const VALUE_BARGE = 'Barge';
    /**
     * Constant for value 'Divert (Connected)'
     * @return string 'Divert (Connected)'
     */
    const VALUE_DIVERT_CONNECTED = 'Divert (Connected)';
    /**
     * Constant for value 'Call PickUp'
     * @return string 'Call PickUp'
     */
    const VALUE_CALL_PICK_UP = 'Call PickUp';
    /**
     * Constant for value 'Other Call PickUp'
     * @return string 'Other Call PickUp'
     */
    const VALUE_OTHER_CALL_PICK_UP = 'Other Call PickUp';
    /**
     * Constant for value 'Group Call PickUp'
     * @return string 'Group Call PickUp'
     */
    const VALUE_GROUP_CALL_PICK_UP = 'Group Call PickUp';
    /**
     * Constant for value 'Mobility'
     * @return string 'Mobility'
     */
    const VALUE_MOBILITY = 'Mobility';
    /**
     * Constant for value 'Meet Me'
     * @return string 'Meet Me'
     */
    const VALUE_MEET_ME = 'Meet Me';
    /**
     * Constant for value 'Report Quality'
     * @return string 'Report Quality'
     */
    const VALUE_REPORT_QUALITY = 'Report Quality';
    /**
     * Constant for value 'Report Caller'
     * @return string 'Report Caller'
     */
    const VALUE_REPORT_CALLER = 'Report Caller';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FORWARD_ALL
     * @uses self::VALUE_PARK
     * @uses self::VALUE_DIVERT_ALERTING
     * @uses self::VALUE_CONFERENCE_LIST
     * @uses self::VALUE_SPEED_DIAL
     * @uses self::VALUE_CALL_BACK
     * @uses self::VALUE_REDIAL
     * @uses self::VALUE_BARGE
     * @uses self::VALUE_DIVERT_CONNECTED
     * @uses self::VALUE_CALL_PICK_UP
     * @uses self::VALUE_OTHER_CALL_PICK_UP
     * @uses self::VALUE_GROUP_CALL_PICK_UP
     * @uses self::VALUE_MOBILITY
     * @uses self::VALUE_MEET_ME
     * @uses self::VALUE_REPORT_QUALITY
     * @uses self::VALUE_REPORT_CALLER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FORWARD_ALL,
            self::VALUE_PARK,
            self::VALUE_DIVERT_ALERTING,
            self::VALUE_CONFERENCE_LIST,
            self::VALUE_SPEED_DIAL,
            self::VALUE_CALL_BACK,
            self::VALUE_REDIAL,
            self::VALUE_BARGE,
            self::VALUE_DIVERT_CONNECTED,
            self::VALUE_CALL_PICK_UP,
            self::VALUE_OTHER_CALL_PICK_UP,
            self::VALUE_GROUP_CALL_PICK_UP,
            self::VALUE_MOBILITY,
            self::VALUE_MEET_ME,
            self::VALUE_REPORT_QUALITY,
            self::VALUE_REPORT_CALLER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
